*Do file for Burke and Liao "Is the price elasticity of demand for coal in China increasing?"
*Please email paul.j.burke@anu.edu.au if you have any questions

clear
set more off
use Burke_Liao.dta
describe

*****************************************************************************************************************************
*VARIABLE CONSTRUCTION
*****************************************************************************************************************************
encode province, gen(pc)
xtset pc year

*Time trend
	gen timetrend=0 if year==1998
	replace timetrend=1+l.timetrend if year>1998	

*Real GDP in 2012 yuan
	gen gdpdeflator_byprovince=nominalgdpindex/realgdpindex*100
	gen gdpdeflator_2012=gdpdeflator_byprovince if year==2012
	bysort province: egen gdpdeflator_2012_1=max(gdpdeflator_2012)
	sort province year
	xtset pc year
	gen gdpdeflator_2012base=gdpdeflator_byprovince/gdpdeflator_2012_1*100
	gen lnrealgdp=ln(gdpnominal/gdpdeflator_2012base*100)

*Coal price index
	gen lncoalpriceindex=ln(coalpriceindex)
	gen realcoalpriceindex_ppi=(coalpriceindex/ppi*100)
	gen lrcpi_ppi=ln(coalpriceindex/ppi*100)	
	gen lrcpi_gdpdeflator=ln(coalpriceindex/gdpdeflator_byprovince*100)
	gen lrcpi_cpi=ln(coalpriceindex/cpi*100)
	gen l2lrcpi_ppi=l2.lrcpi_ppi

*Energy efficiency assignments
	gen enterp_ee_ass=0
	replace enterp_ee_ass=enterprises_ass_06_10 if year>2005 & year<2011
	replace enterp_ee_ass=enterprises_ass_11_12 if year>2010 & year<2013

*Operations
	gen lncoalcon=ln(coalconsumption)
	gen coalcon_pc=coalconsumption/(population*10000)*1000000
	gen soeshare_rev=soe_revenue/industrialrevenue*100
	gen lrgpi_ppi=ln(gasolineprice/ppi*100)
	replace retired_tc_perc=0 if year<2006
	gen interact=timetrend*lrcpi_ppi
	gen linteract=l.lrcpi_ppi*timetrend
	gen l2interact=l2.lrcpi_ppi*timetrend
	gen lnrealgdp_time=lnrealgdp*timetrend

*Late dummy
	gen late=0
	replace late=1 if year>2007
	gen late_int=late*lrcpi_ppi
	
*Sample
	xi: xtreg lncoalcon lrcpi_ppi lnrealgdp year, fe cluster(pc)
	generate sample=1 if e(sample)
	
sort province year
xtset pc year

*****************************************************************************************************************************
*UNIT ROOT TESTS IN LEVELS: Im-Pesaran-Shin
*****************************************************************************************************************************
	xtunitroot ips lncoalcon, trend demean
	bysort province: egen counter=count(lrcpi_ppi)
	sort province year
	xtset pc year
	xtunitroot ips lrcpi_ppi if counter>10, trend demean
	xtunitroot ips lnrealgdp, trend demean
	
	*Conclusion: Based on IPS tests, panel unit root tests indicate that the only variable that appears to have a unit root for all provinces is GDP. Results similar if we exclude GDP from our regressions. e.g.
		xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact timetrend, fe cluster(pc)
			gen el_max_nogdp=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14
			list el_max_nogdp if province=="Beijing" & year==2012
			test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
		
*****************************************************************************************************************************
*TABLES
*****************************************************************************************************************************
*Table 1
	summ lncoalcon lrcpi_ppi timetrend lnrealgdp secondaryshare soeshare_rev enterp_ee_ass retired_tc_perc lrgpi_ppi if sample==1

*Hausman test
	*For column 4 Table 1
		xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp timetrend, fe
			estimates store fixed
		xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp timetrend, re
			estimates store random	
			hausman fixed random
			*Result: prefer FE
			
*Table 2: Static (columns 1-5)
	xi: xtreg lncoalcon lrcpi_ppi lnrealgdp timetrend, fe cluster(pc)
		estimates store r1
	xi: xtreg lncoalcon lrcpi_ppi lnrealgdp timetrend if year<=2007, fe cluster(pc)
		estimates store r2
	xi: xtreg lncoalcon lrcpi_ppi lnrealgdp timetrend if year>2007, fe cluster(pc)
		estimates store r3
	xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp timetrend, fe cluster(pc)
		estimates store r4
		test _b[lrcpi_ppi]+_b[interact]*14=0
		gen elasticity_ppi=_b[lrcpi_ppi]+_b[interact]*timetrend
		list elasticity_ppi if province=="Beijing" & year==2012

*Table 2: Lags (columns 6-10)
	xi: xtreg lncoalcon lrcpi_ppi l.lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend, fe cluster(pc)
		estimates store r5
		test _b[lrcpi_ppi]+_b[l.lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend, fe cluster(pc)
		estimates store r6
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend if year<=2007, fe cluster(pc)
		estimates store r7
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend if year>2007, fe cluster(pc)
		estimates store r8
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp timetrend, fe cluster(pc)
		estimates store r9
		gen el_12=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14
		list el_12 if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
			
		gen el_07=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9
		list el_07 if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9=0	
		
		gen el_02=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4
		list el_02 if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4=0	
		
		gen el_98=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]
		list el_98 if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0	
		
		xml_tab r1 r2 r3 r4 r5 r6 r7 r8 r9, stats(r2 N N_g) below sheet("Table 2") format(nTLR2) replace save(stataresults)

		*Commencing "late" period later
			xi: xtreg lncoalcon lrcpi_ppi lnrealgdp timetrend if year>2008, fe cluster(pc)
			xi: xtreg lncoalcon lrcpi_ppi lnrealgdp timetrend if year>2009, fe cluster(pc)

			xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend if year>2008, fe cluster(pc)
				test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
			xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend if year>2009, fe cluster(pc)
				test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0

		*Commencing "late" period earlier
			xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend if year>2006, fe cluster(pc)		
				test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
		
		*Specification 2: Random effects
			*Static (columns 1-5)
				xi: xtreg lncoalcon lrcpi_ppi lnrealgdp timetrend, re cluster(pc)
					estimates store r1
				xi: xtreg lncoalcon lrcpi_ppi lnrealgdp timetrend if year<=2007, re cluster(pc)
					estimates store r2
				xi: xtreg lncoalcon lrcpi_ppi lnrealgdp timetrend if year>2007, re cluster(pc)
					estimates store r3
				xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp timetrend, re cluster(pc)
					estimates store r4
					test _b[lrcpi_ppi]+_b[interact]*14=0
					gen elasticity_ppi_re=_b[lrcpi_ppi]+_b[interact]*timetrend
					list elasticity_ppi_re if province=="Beijing" & year==2012

			*Lags (columns 6-10)
				xi: xtreg lncoalcon lrcpi_ppi l.lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend, re cluster(pc)
					estimates store r5
					test _b[lrcpi_ppi]+_b[l.lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
				xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend, re cluster(pc)
					estimates store r6
					test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
				xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend if year<=2007, re cluster(pc)
					estimates store r7
					test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
				xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi lnrealgdp timetrend if year>2007, re cluster(pc)
					estimates store r8
					test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]=0
				xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp timetrend, re cluster(pc)
					estimates store r9
					gen el_max_re=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14
					list el_max_re if province=="Beijing" & year==2012
					test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
					xml_tab r1 r2 r3 r4 r5 r6 r7 r8 r9 , stats(r2 N N_g) below sheet("Table 2 Specification 2") format(nTLR2) append save(stataresults)	
		
	*Specification 3: Using level, constructed using Input-Output Table
		gen coalpriceindex_2007=coalpriceindex if year==2007
		bysort province: egen coalpriceindex_2007_1=max(coalpriceindex_2007)
		bysort province: egen i_o_elecprice_07=max(i_o_electricitycoalprice_2007)
		sort province year
		xtset pc year
		gen coalpriceindex_07_new=coalpriceindex/coalpriceindex_2007_1*100
		gen coal_pr_i_o=coalpriceindex_07_new*i_o_elecprice_07/100
		gen lcoal_pr_i_o=ln(coal_pr_i_o/ppi*100)
		gen interact_i_o=lcoal_pr_i_o*timetrend
		gen linteract_i_o=l.lcoal_pr_i_o*timetrend
		gen l2interact_i_o=l2.lcoal_pr_i_o*timetrend
	
	*Static (columns 1-5)
		xi: reg lncoalcon lcoal_pr_i_o lnrealgdp timetrend, cluster(pc)
			estimates store r1
		xi: reg lncoalcon lcoal_pr_i_o lnrealgdp timetrend if year<=2007, cluster(pc)
			estimates store r2
		xi: reg lncoalcon lcoal_pr_i_o lnrealgdp timetrend if year>2007, cluster(pc)
			estimates store r3
		xi: reg lncoalcon lcoal_pr_i_o interact_i_o lnrealgdp timetrend, cluster(pc)
			estimates store r4
			test _b[lcoal_pr_i_o]+_b[interact_i_o]*14=0
			gen elasticity_ppi_ols=_b[lcoal_pr_i_o]+_b[interact_i_o]*timetrend
			list elasticity_ppi_ols if province=="Beijing" & year==2012

	*Lags (columns 6-10)
		xi: reg lncoalcon lcoal_pr_i_o l.lcoal_pr_i_o l2.lcoal_pr_i_o lnrealgdp timetrend, cluster(pc)
			estimates store r5
			test _b[lcoal_pr_i_o]+_b[l.lcoal_pr_i_o]+_b[l2.lcoal_pr_i_o]=0
		xi: reg lncoalcon lcoal_pr_i_o l2.lcoal_pr_i_o lnrealgdp timetrend, cluster(pc)
			estimates store r6
			test _b[lcoal_pr_i_o]+_b[l2.lcoal_pr_i_o]=0
		xi: reg lncoalcon lcoal_pr_i_o l2.lcoal_pr_i_o lnrealgdp timetrend if year<=2007, cluster(pc)
			estimates store r7
			test _b[lcoal_pr_i_o]+_b[l2.lcoal_pr_i_o]=0
		xi: reg lncoalcon lcoal_pr_i_o l2.lcoal_pr_i_o lnrealgdp timetrend if year>2007, cluster(pc)
			estimates store r8
			test _b[lcoal_pr_i_o]+_b[l2.lcoal_pr_i_o]=0
		xi: reg lncoalcon lcoal_pr_i_o l2.lcoal_pr_i_o interact_i_o l2interact_i_o lnrealgdp timetrend, cluster(pc)
			estimates store r9
			gen el_max_ols=_b[lcoal_pr_i_o]+_b[l2.lcoal_pr_i_o]+_b[interact_i_o]*14+_b[l2interact_i_o]*14
			list el_max_ols if province=="Beijing" & year==2012
			test _b[lcoal_pr_i_o]+_b[l2.lcoal_pr_i_o]+_b[interact_i_o]*14+_b[l2interact_i_o]*14=0
			xml_tab r1 r2 r3 r4 r5 r6 r7 r8 r9, stats(r2 N N_g) below sheet("Table 2 Specification 3") format(nTLR2) append save(stataresults)
			
*Table 3
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp timetrend, fe cluster(pc)
		estimates store t1
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp lnrealgdp_time timetrend, fe cluster(pc)
		estimates store t2
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp secondaryshare timetrend, fe cluster(pc)
		estimates store t3
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp soeshare_rev timetrend, fe cluster(pc)
		estimates store t4
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp enterp_ee_ass timetrend, fe cluster(pc)
		estimates store t5
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp retired_tc_perc timetrend, fe cluster(pc)
		estimates store t6
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp lrgpi_ppi timetrend, fe cluster(pc)
		estimates store t7
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp secondaryshare soeshare_rev enterp_ee_ass retired_tc_perc lrgpi_ppi timetrend, fe cluster(pc)
		estimates store t8
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*4+_b[interact]*4=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*9+_b[interact]*9=0
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
		xml_tab t1 t2 t3 t4 t5 t6 t7 t8, stats(r2 N N_g) below sheet("Table 3") format(nTLR2) append save(stataresults) 

*Table 3 - static estimates
	xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp timetrend, fe cluster(pc)
		estimates store _t1
		gen el_t1=_b[lrcpi_ppi]+_b[interact]*14
		codebook el_t1
		test _b[lrcpi_ppi]+_b[interact]*14=0
	
	xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp lnrealgdp_time timetrend, fe cluster(pc)
		estimates store _t2
		gen el_t2=_b[lrcpi_ppi]+_b[interact]*14
		codebook el_t2
		test _b[lrcpi_ppi]+_b[interact]*14=0
		
	xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp secondaryshare timetrend, fe cluster(pc)
		estimates store _t3
		gen el_t3=_b[lrcpi_ppi]+_b[interact]*14
		codebook el_t3
		test _b[lrcpi_ppi]+_b[interact]*14=0

	xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp soeshare_rev timetrend, fe cluster(pc)
		estimates store _t4
		gen el_t4=_b[lrcpi_ppi]+_b[interact]*14
		codebook el_t4
		test _b[lrcpi_ppi]+_b[interact]*14=0

	xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp enterp_ee_ass timetrend, fe cluster(pc)
		estimates store _t5
		gen el_t5=_b[lrcpi_ppi]+_b[interact]*14
		codebook el_t5
		test _b[lrcpi_ppi]+_b[interact]*14=0
	
	xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp retired_tc_perc timetrend, fe cluster(pc)
		estimates store _t6
		gen el_t6=_b[lrcpi_ppi]+_b[interact]*14
		codebook el_t6
		test _b[lrcpi_ppi]+_b[interact]*14=0
	
	xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp lrgpi_ppi timetrend, fe cluster(pc)
		estimates store _t7
		gen el_t7=_b[lrcpi_ppi]+_b[interact]*14
		codebook el_t7
		test _b[lrcpi_ppi]+_b[interact]*14=0
	
	xi: xtreg lncoalcon lrcpi_ppi interact lnrealgdp secondaryshare soeshare_rev enterp_ee_ass retired_tc_perc lrgpi_ppi timetrend, fe cluster(pc)
		estimates store _t8
		gen el_t8=_b[lrcpi_ppi]+_b[interact]*14
		codebook el_t8
		test _b[lrcpi_ppi]+_b[interact]*14=0
		xml_tab _t1 _t2 _t3 _t4 _t5 _t6 _t7 _t8, stats(r2 N N_g) below sheet("Table 3 Static") format(nTLR2) append save(stataresults) 

*Table 4
	*1-year change
		gen diff_rcpi_ppi_1=lrcpi_ppi-l.lrcpi_ppi
		gen diff_lncoalcon_1=lncoalcon-l.lncoalcon
		gen diff_lnrealgdp_1=lnrealgdp-l.lnrealgdp
		gen diff_rcpi_ppitt_1=diff_rcpi_ppi_1*timetrend

				xtunitroot ips diff_lnrealgdp_1, trend demean
				xtunitroot ips diff_lncoalcon_1, trend demean
				xtunitroot ips diff_rcpi_ppi_1 if counter>10, trend demean
		
		reg diff_lncoalcon_1 diff_rcpi_ppi_1 diff_lnrealgdp_1 diff_rcpi_ppitt_1 timetrend, cluster(pc)
			gen el_x_1_02=_b[diff_rcpi_ppi_1]+_b[diff_rcpi_ppitt_1]*4
			gen el_x_1_07=_b[diff_rcpi_ppi_1]+_b[diff_rcpi_ppitt_1]*9
			gen el_x_1_12=_b[diff_rcpi_ppi_1]+_b[diff_rcpi_ppitt_1]*14
			codebook el_x_1_02 el_x_1_07 el_x_1_12  
			test _b[diff_rcpi_ppi_1]+_b[diff_rcpi_ppitt_1]*4=0
			test _b[diff_rcpi_ppi_1]+_b[diff_rcpi_ppitt_1]*9=0
			test _b[diff_rcpi_ppi_1]+_b[diff_rcpi_ppitt_1]*14=0

			estimates store table_4_1
			
	*2-year change
		gen diff_rcpi_ppi_2=lrcpi_ppi-l2.lrcpi_ppi
		gen diff_lncoalcon_2=lncoalcon-l2.lncoalcon
		gen diff_lnrealgdp_2=lnrealgdp-l2.lnrealgdp
		gen diff_rcpi_ppitt_2=diff_rcpi_ppi_2*timetrend

		reg diff_lncoalcon_2 diff_rcpi_ppi_2 diff_lnrealgdp_2 diff_rcpi_ppitt_2 timetrend if year==2012 | year==2010 | year==2008 | year==2006 | year==2004 | year==2002 | year==2000, cluster(pc)
			gen el_x_2_12=_b[diff_rcpi_ppi_2]+_b[diff_rcpi_ppitt_2]*14
			gen el_x_2_07=_b[diff_rcpi_ppi_2]+_b[diff_rcpi_ppitt_2]*9
			gen el_x_2_02=_b[diff_rcpi_ppi_2]+_b[diff_rcpi_ppitt_2]*4
			codebook  el_x_2_02 el_x_2_07 el_x_2_12
			test _b[diff_rcpi_ppi_2]+_b[diff_rcpi_ppitt_2]*4=0
			test _b[diff_rcpi_ppi_2]+_b[diff_rcpi_ppitt_2]*9=0
			test _b[diff_rcpi_ppi_2]+_b[diff_rcpi_ppitt_2]*14=0
			estimates store table_4_2	
			
	*3-year change
		gen diff_rcpi_ppi_3=lrcpi_ppi-l3.lrcpi_ppi
		gen diff_lncoalcon_3=lncoalcon-l3.lncoalcon
		gen diff_lnrealgdp_3=lnrealgdp-l3.lnrealgdp
		gen diff_rcpi_ppitt_3=diff_rcpi_ppi_3*timetrend

		reg diff_lncoalcon_3 diff_rcpi_ppi_3 diff_lnrealgdp_3 diff_rcpi_ppitt_3 timetrend if year==2012 | year==2009 | year==2006 | year==2003, cluster(pc)
			gen el_x_3_12=_b[diff_rcpi_ppi_3]+_b[diff_rcpi_ppitt_3]*14
			gen el_x_3_07=_b[diff_rcpi_ppi_3]+_b[diff_rcpi_ppitt_3]*9
			gen el_x_3_02=_b[diff_rcpi_ppi_3]+_b[diff_rcpi_ppitt_3]*4
			codebook el_x_3_02 el_x_3_07 el_x_3_12
			test _b[diff_rcpi_ppi_3]+_b[diff_rcpi_ppitt_3]*4=0
			test _b[diff_rcpi_ppi_3]+_b[diff_rcpi_ppitt_3]*9=0
			test _b[diff_rcpi_ppi_3]+_b[diff_rcpi_ppitt_3]*14=0
		
			estimates store table_4_3	
			
	*4-year change
		gen diff_rcpi_ppi_4=lrcpi_ppi-l4.lrcpi_ppi
		gen diff_lncoalcon_4=lncoalcon-l4.lncoalcon
		gen diff_lnrealgdp_4=lnrealgdp-l4.lnrealgdp
		gen diff_rcpi_ppitt_4=diff_rcpi_ppi_4*timetrend

		reg diff_lncoalcon_4 diff_rcpi_ppi_4 diff_lnrealgdp_4 diff_rcpi_ppitt_4 timetrend if year==2012 | year==2008 | year==2004, cluster(pc)
		
			gen el_x_4_12=_b[diff_rcpi_ppi_4]+_b[diff_rcpi_ppitt_4]*14
			gen el_x_4_07=_b[diff_rcpi_ppi_4]+_b[diff_rcpi_ppitt_4]*9
			gen el_x_4_02=_b[diff_rcpi_ppi_4]+_b[diff_rcpi_ppitt_4]*4
			codebook  el_x_4_02 el_x_4_07 el_x_4_12
			test _b[diff_rcpi_ppi_4]+_b[diff_rcpi_ppitt_4]*4=0
			test _b[diff_rcpi_ppi_4]+_b[diff_rcpi_ppitt_4]*9=0
			test _b[diff_rcpi_ppi_4]+_b[diff_rcpi_ppitt_4]*14=0
			estimates store table_4_4				
			
	*5-year change
		gen diff_rcpi_ppi_5=lrcpi_ppi-l5.lrcpi_ppi
		gen diff_lncoalcon_5=lncoalcon-l5.lncoalcon
		gen diff_lnrealgdp_5=lnrealgdp-l5.lnrealgdp
		gen diff_rcpi_ppitt_5=diff_rcpi_ppi_5*timetrend

		reg diff_lncoalcon_5 diff_rcpi_ppi_5 diff_lnrealgdp_5 diff_rcpi_ppitt_5 timetrend if year==2012 | year==2007, cluster(pc)
			gen el_x_5_12=_b[diff_rcpi_ppi_5]+_b[diff_rcpi_ppitt_5]*14
			gen el_x_5_07=_b[diff_rcpi_ppi_5]+_b[diff_rcpi_ppitt_5]*9
			gen el_x_5_02=_b[diff_rcpi_ppi_5]+_b[diff_rcpi_ppitt_5]*4
			codebook  el_x_5_02 el_x_5_07 el_x_5_12
			test _b[diff_rcpi_ppi_5]+_b[diff_rcpi_ppitt_5]*4=0
			test _b[diff_rcpi_ppi_5]+_b[diff_rcpi_ppitt_5]*9=0
			test _b[diff_rcpi_ppi_5]+_b[diff_rcpi_ppitt_5]*14=0
			estimates store table_4_5
			
		xml_tab table_4_1 table_4_2 table_4_3 table_4_4 table_4_5, stats(r2 N N_g) below sheet("Table 4") format(nTLR2) append save(stataresults) 
					
*****************************************************************************************************************************
*OTHER REGRESSIONS
*****************************************************************************************************************************
*Earlier lags
	*3rd
		xi: xtreg lncoalcon lrcpi_ppi l3.lrcpi_ppi lnrealgdp timetrend if year<2008, fe cluster(pc)
			test _b[lrcpi_ppi]+_b[l3.lrcpi_ppi]=0
		xi: xtreg lncoalcon lrcpi_ppi l3.lrcpi_ppi lnrealgdp timetrend if year>2007, fe cluster(pc)
			test _b[lrcpi_ppi]+_b[l3.lrcpi_ppi]=0

	*4th
		xi: xtreg lncoalcon lrcpi_ppi l4.lrcpi_ppi lnrealgdp timetrend if year<2008, fe cluster(pc)
			test _b[lrcpi_ppi]+_b[l4.lrcpi_ppi]=0
		xi: xtreg lncoalcon lrcpi_ppi l4.lrcpi_ppi lnrealgdp timetrend if year>2007, fe cluster(pc)		
			test _b[lrcpi_ppi]+_b[l4.lrcpi_ppi]=0

*Dropping current price
		xi: xtreg lncoalcon l2.lrcpi_ppi lnrealgdp timetrend if year>2007, fe cluster(pc)		
			
*Estimates without a time trend
	xi: xtreg lncoalcon lrcpi_ppi lnrealgdp, fe cluster(pc)
	xi: xtreg lncoalcon lrcpi_ppi lnrealgdp if year>2007, fe cluster(pc)
			
*Using no deflator
	gen lncoalpriceindex_int=lncoalpriceindex*timetrend
	gen l2lncoalpriceindex_int=l2.lncoalpriceindex*timetrend		
		
	xi: xtreg lncoalcon lncoalpriceindex l2.lncoalpriceindex lncoalpriceindex_int l2lncoalpriceindex_int lnrealgdp timetrend, fe cluster(pc)
		test _b[lncoalpriceindex]+_b[l2.lncoalpriceindex]+14*_b[lncoalpriceindex_int]+14*_b[l2lncoalpriceindex_int]=0
	
*Alternative deflators
	gen lrcpi_gdpdeflator_int=lrcpi_gdpdeflator*timetrend
	gen l2rcpi_gdpdeflator_int=l2.lrcpi_gdpdeflator*timetrend
	
	gen lrcpi_cpi_int=lrcpi_cpi*timetrend
	gen l2rcpi_cpi_int=l2.lrcpi_cpi*timetrend	

	xi: xtreg lncoalcon lrcpi_gdpdeflator l2.lrcpi_gdpdeflator lnrealgdp timetrend lrcpi_gdpdeflator_int l2rcpi_gdpdeflator_int, fe cluster(pc)
		test _b[lrcpi_gdpdeflator]+_b[l2.lrcpi_gdpdeflator]+14*_b[lrcpi_gdpdeflator_int]+14*_b[l2rcpi_gdpdeflator_int]=0
	
	xi: xtreg lncoalcon lrcpi_cpi l2.lrcpi_cpi lnrealgdp timetrend lrcpi_cpi_int l2rcpi_cpi_int, fe cluster(pc)
		test _b[lrcpi_cpi]+_b[l2.lrcpi_cpi]+14*_b[lrcpi_cpi_int]+14*_b[l2rcpi_cpi_int]=0	

*Control: profit:cost ratio
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp profit_cost timetrend, fe cluster(pc)
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0
		gen p_c_int=profit_cost*lrcpi_ppi
	xi: xtreg lncoalcon lrcpi_ppi p_c_int interact lnrealgdp profit_cost timetrend, fe cluster(pc)	
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi p_c_int interact l2interact lnrealgdp profit_cost timetrend, fe cluster(pc)	

*Excluding one region at a time
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp timetrend if region~="north", fe cluster(pc)
		gen el_max_excn=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14
		list el_max_excn if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0	

	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp timetrend if region~="northeast", fe cluster(pc)
		gen el_max_excne=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14
		list el_max_excne if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0		

	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp timetrend if region~="east", fe cluster(pc)
		gen el_max_exce=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14
		list el_max_exce if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0		

	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp timetrend if region~="southcentral", fe cluster(pc)
		gen el_max_excsc=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14
		list el_max_excsc if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0		
			
	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp timetrend if region~="southwest", fe cluster(pc)
		gen el_max_excsw=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14
		list el_max_excsw if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0		

	xi: xtreg lncoalcon lrcpi_ppi l2.lrcpi_ppi interact l2interact lnrealgdp timetrend if region~="northwest", fe cluster(pc)
		gen el_max_excnw=_b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14
		list el_max_excnw if province=="Beijing" & year==2012
		test _b[lrcpi_ppi]+_b[l2.lrcpi_ppi]+_b[l2interact]*14+_b[interact]*14=0		

*IV
	*Log real international coal prices. 
		*Weight by national PPI deflator so as to avoid province-by-province variation in the deflator.
			gen lncoalprice_ausd=ln(coalprice_usd_imf/industrial_ppi_china*100)
			xi: xtivreg2 lncoalcon (lrcpi_ppi = lncoalprice_ausd) lnrealgdp timetrend, fe cluster(pc) first

			gen ln_bpmeasure=ln(asian_marker_price_bp_index/industrial_ppi_china*100)
			xi: xtivreg2 lncoalcon (lrcpi_ppi = ln_bpmeasure) lnrealgdp timetrend, fe cluster(pc) first

			gen lnqing_windinfo=ln(qing_windinfo/industrial_ppi_china*100)
			xi: xtivreg2 lncoalcon (lrcpi_ppi = lnqing_windinfo) lnrealgdp timetrend, fe cluster(pc) first
		
		*Weight by railway fredight costs or distance to port
			gen railwayweighted=ln(coalprice_usd_imf/railwayfreightrate_port)
			xi: xtivreg2 lncoalcon (lrcpi_ppi = railwayweighted) lnrealgdp timetrend, fe cluster(pc) first

			gen roadweighted=ln(coalprice_usd_imf/roaddistance_port)
			xi: xtivreg2 lncoalcon (lrcpi_ppi = roadweighted) lnrealgdp timetrend, fe cluster(pc) first	
		
	*Coal reserves
		gen lncoalreserves=ln(coalreserves)
		xi: xtivreg2 lncoalcon (lrcpi_ppi = coalreserves) lnrealgdp timetrend, fe cluster(pc) first
		xi: xtivreg2 lncoalcon (lrcpi_ppi = lncoalreserves) lnrealgdp timetrend, fe cluster(pc) first

*****************************************************************************************************************************
*FIGURES
*****************************************************************************************************************************
*Variable definitions and sources are as in paper.

*Figure 1
	insheet using "fig1.csv", clear
	twoway (line china row year, lwidth(medthick medthick) lcolor(black blue) lpattern(solid dash)), text(1800 1990 "Rest of the world", size(medium) tstyle(bold) color(blue)) text(1100 2001.5 "China", size(medium) tstyle(bold)) scheme(s1color) ytitle("Million tonnes oil equivalent", margin(small)) xlab(1965 1970 1980 1990 2000 2010) ylab(0(500)2000, nogrid angle(0)) xtitle("") legend(off) 

*Figure 2
	insheet using "fig2.csv", clear
	gen man=electricity+manufacturing
	gen other_1=electricity+manufacturing+other
	twoway (area other_1 year, fcolor(white) lcolor(black)) (area man year, fcolor(gray) lcolor(black)) (area electricity year, fcolor(black) lcolor(black)), scheme(s1color) ylab(0(1)3, nogrid angle(0)) ytitle("Index (1994 total = 1)", margin(small)) xtitle("") xlabel(1994(3)2012) legend(label(3 "Electricity") label(2 "Manufacturing") label(1 "Other") order(3 2 1) rows(1))
	
*Figure 3
	insheet using "fig3.csv", clear
	generate oil_1=coal+oil
	generate natgas_1=coal+oil+natgas
	twoway (area natgas_1 year, fcolor(white) lcolor(black)) (area oil_1 year, fcolor(gray) lcolor(black)) (area coal year, fcolor(black) lcolor(black)), scheme(s1color) ylab(0(2000)8000, nogrid angle(0)) ytitle("Million tonnes CO{sub:2}", margin(small)) xtitle("") legend(label(1 "Natural gas") label(2 "Oil") label(3 "Coal") order(3 2 1) rows(1))
	
*Figure 4
	insheet using "fig4.csv", clear
	twoway (line coalpriceindex	industrial_ppi index_q5500k year, lwidth(medthick medthick) lcolor(black gray black) lpattern(solid dash dot)), text(2.8 2005.8 "Qinhuangdao", size(medium) tstyle(bold) color(black)) text(2 2009 "Coal price", size(medium) tstyle(bold) color(black)) text(1.4 2008.8 "Industrial producer prices", size(medium) tstyle(bold) color(black)) ytitle("Index (1998 = 1. Qinhuangdao index = coal price index in 2003)", margin(small) size(small)) ylab(0.5(0.5)3, nogrid angle(0)) xtitle("") legend(off) xlab(1998(2)2013) scheme(s1color)

*Figure 5 constructed using the data for coalcon_pc
